%% reading data
clear all
[FileNames,PathName,FilterIndex] = uigetfile('*.czi;*.nd2','Select one or more files to make movies...','MultiSelect','on');

  if ~iscell(FileNames)
        numFiles=1;
        FileName=FileNames;
    elseif iscell(FileNames)
        numFiles=length(FileNames);
        FileName=FileNames{1};
  end
% load data
[data,specs]=readOMEFile_new(PathName,FileName);
%% prompt user to define type of movie file, frame rate and whether to save raw data or immobile component filtered
prompt={'What file type (mp4,avi) would you like to export?','What frame rate do you want to save video (fps)?','Immobile filter data (y or n)?','What is the acquisition time per frame (s)','What is the pixel size (microns)?'};
dlg_title = 'Make Movie';
num_lines = 1;
options.Resize='on';
answer = inputdlg(prompt,dlg_title,num_lines,{'mp4','30','y',num2str(specs.timeFrame),num2str(specs.pixelSize)},options);
MovType=answer(1);
FrameRate=str2double(answer(2));
filt=answer(3);
timeFrame=str2double(answer(4));
pixelSize=str2double(answer(5));
%%

for file=1:numFiles
    clearvars -except FileNames PathName file MovType FrameRate  filt timeFrame pixelSize numFiles
    if ~iscell(FileNames)
        FileName=FileNames;
    elseif iscell(FileNames)
        FileName=FileNames{file};
    end
% load data
[data,specs]=readOMEFile_new(PathName,FileName);

%% open file one by one and export movie of mobile data
if strcmp('y',filt)
% filtering immobile component
data = fft(double(data),[],3);
avPixInt = mean(mean(data(:,:,1)))/size(data,3);
data(:,:,1) = 0;
data = (real(ifft(data,[],3))+avPixInt);
data=data(3:end-3,3:end-3,:);
% now Gaussian denoising
[data,h2]=smoothSeries(data,1.5,'g','p');
end
% define movie file
if strcmp(MovType,'mp4')
    if strcmp('y',filt)
  writerObj1 = VideoWriter([PathName FileName(1:end-4)  '_filtered_' num2str(FrameRate)  'fps.mp4'],'MPEG-4');
    elseif strcmp('n',filt)
  writerObj1 = VideoWriter([PathName FileName(1:end-4)  '_raw_' num2str(FrameRate)  'fps.mp4'],'MPEG-4');
    end
elseif strcmp(MovType,'avi')
    if strcmp('y',filt)
    writerObj1 = VideoWriter([PathName FileName(1:end-4)  '_filtered_' num2str(FrameRate)  'fps.avi'],'Uncompressed AVI');
    elseif strcmp('n',filt)
    writerObj1 = VideoWriter([PathName FileName(1:end-4)  '_raw_' num2str(FrameRate)  'fps.avi'],'Uncompressed AVI');
    end
end
writerObj1.FrameRate =FrameRate;
open(writerObj1);
f = waitbar(0,['Exporting Movie No.' num2str(file) ' of total ' num2str(length(FileNames)) ' Files']);
close all
for i=1:size(data,3)
    h = figure;set(h, 'Visible', 'off');
    imagesc(data(:,:,i));axis off;axis equal;colormap(gray)
    set(gcf,'Color',[1 1 0.99])
    hold on
    text(5,10,['t= ' num2str((i*timeFrame)) ' s'],'Color',[1 1 1],'Fontsize',30)   
    hold on
    num10=round(10/pixelSize);
    hold on 
    plot(size(data,2)-num10-20:size(data,2)-21,(size(data,1)-5)*ones(1,num10),'-','Color',[1 1 1],'LineWidth',5)
    text(size(data,2)-num10-25,(size(data,1)-15),'10 \mum','Color',[1 1 1],'Fontsize',30) 
    set(gcf,'Units','normalized','Position',[0.05 0.05 0.8 0.8])
    frame = getframe(1);
    writeVideo(writerObj1,frame);
    close(h)
    waitbar(i/size(data,3),f,['Exporting Movie No.' num2str(file) ' of total ' num2str(length(FileNames)) ' Files']);
end
close(f)
close(writerObj1);
end